<?php
/* --------------------------------------------------------------
   AllParcelServicesRequested.php 2020-03-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\Events;

use Gambio\Admin\ParcelService\Interfaces\ParcelServiceSqlCriteria;
use Gambio\Admin\ParcelService\Interfaces\ParcelServiceSqlPagination;

/**
 * Class AllParcelServicesRequested
 *
 * @package Gambio\Admin\ParcelService\Events
 */
class AllParcelServicesRequested
{
    /**
     * @var ParcelServiceSqlCriteria
     */
    private $criteria;
    
    
    /**
     * @var ParcelServiceSqlPagination
     */
    private $pagination;
    
    
    /**
     * AllParcelServicesRequested constructor.
     *
     * @param ParcelServiceSqlCriteria   $criteria
     * @param ParcelServiceSqlPagination $pagination
     */
    private function __construct(
        ParcelServiceSqlCriteria $criteria,
        ParcelServiceSqlPagination $pagination
    ) {
        $this->criteria   = $criteria;
        $this->pagination = $pagination;
    }
    
    
    /**
     * @param ParcelServiceSqlCriteria   $criteria
     * @param ParcelServiceSqlPagination $pagination
     *
     * @return AllParcelServicesRequested
     */
    public static function create(
        ParcelServiceSqlCriteria $criteria,
        ParcelServiceSqlPagination $pagination
    ): AllParcelServicesRequested {
        return new self($criteria, $pagination);
    }
    
    
    /**
     * @return ParcelServiceSqlCriteria
     */
    public function criteria(): ParcelServiceSqlCriteria
    {
        return $this->criteria;
    }
    
    
    /**
     * @return ParcelServiceSqlPagination
     */
    public function pagination(): ParcelServiceSqlPagination
    {
        return $this->pagination;
    }
    
    
    /**
     * @param ParcelServiceSqlCriteria $criteria
     */
    public function replaceCriteria(ParcelServiceSqlCriteria $criteria): void
    {
        $this->criteria = $criteria;
    }
    
    
    /**
     * @param ParcelServiceSqlPagination $pagination
     */
    public function replacePagination(ParcelServiceSqlPagination $pagination): void
    {
        $this->pagination = $pagination;
    }
}